import { Toaster } from "@/components/ui/toaster";
import { Toaster as Sonner } from "@/components/ui/sonner";
import { TooltipProvider } from "@/components/ui/tooltip";
import { QueryClient, QueryClientProvider } from "@tanstack/react-query";
import { BrowserRouter, Routes, Route } from "react-router-dom";
import { AuthProvider } from "./components/Auth/AuthProvider";
import { AuthPage } from "./components/Auth/AuthPage";
import { ProtectedRoute } from "./components/Layout/ProtectedRoute";
import { MainLayout } from "./components/Layout/MainLayout";
import { DashboardOverview } from "./components/Dashboard/DashboardOverview";
import { RiskManagementMain } from "./components/RiskManagement/RiskManagementMain";
import { CarbonAccountingMain } from "./components/CarbonAccounting/CarbonAccountingMain";
import { PortfolioMain } from "./components/Portfolio/PortfolioMain";
import { NetZeroMain } from "./components/NetZero/NetZeroMain";
import { SupplyChainMain } from "./components/SupplyChain/SupplyChainMain";
import DataManagement from "./pages/DataManagement";
import ESGReporting from "./pages/ESGReporting";
import NotFound from "./pages/NotFound";
import { SettingsMain } from "./components/Settings/SettingsMain";

const queryClient = new QueryClient();

const App = () => (
  <QueryClientProvider client={queryClient}>
    <TooltipProvider>
      <AuthProvider>
        <Toaster />
        <Sonner />
        <BrowserRouter>
          <Routes>
            <Route path="/auth" element={<AuthPage />} />
            <Route path="/" element={
              <ProtectedRoute>
                <MainLayout />
              </ProtectedRoute>
            }>
              <Route index element={<DashboardOverview />} />
              <Route path="/data-management" element={<DataManagement />} />
              <Route path="/reporting" element={<ESGReporting />} />
              <Route path="/risk-management" element={
                <div className="p-6">
                  <RiskManagementMain />
                </div>
              } />
              <Route path="/carbon-accounting" element={
                <div className="p-6">
                  <CarbonAccountingMain />
                </div>
              } />
              <Route path="/portfolio" element={
                <div className="p-6">
                  <PortfolioMain />
                </div>
              } />
              <Route path="/net-zero" element={
                <div className="p-6">
                  <NetZeroMain />
                </div>
              } />
              <Route path="/supply-chain" element={
                <div className="p-6">
                  <SupplyChainMain />
                </div>
              } />
              <Route path="/settings" element={
                <div className="p-6">
                  <SettingsMain />
                </div>
              } />
            </Route>
            <Route path="*" element={<NotFound />} />
          </Routes>
        </BrowserRouter>
      </AuthProvider>
    </TooltipProvider>
  </QueryClientProvider>
);

export default App;
