
import React from 'react';
import {
  Dialog,
  DialogContent,
  DialogHeader,
  DialogTitle,
  DialogFooter,
} from '@/components/ui/dialog';
import { Button } from '@/components/ui/button';
import { ScrollArea } from '@/components/ui/scroll-area';

interface UserAgreementModalProps {
  open: boolean;
  onOpenChange: (open: boolean) => void;
  onAccept: () => void;
}

export const UserAgreementModal = ({ open, onOpenChange, onAccept }: UserAgreementModalProps) => {
  return (
    <Dialog open={open} onOpenChange={onOpenChange}>
      <DialogContent className="max-w-4xl max-h-[90vh]">
        <DialogHeader>
          <DialogTitle>User Agreement and Data Usage Policy</DialogTitle>
        </DialogHeader>
        
        <ScrollArea className="h-[60vh] pr-4">
          <div className="space-y-6 text-sm">
            <section>
              <h3 className="text-lg font-semibold mb-2">1. ACCEPTANCE OF TERMS</h3>
              <p>
                By accessing and using the GreenCard Sustainability Manager platform ("Platform"), you agree to be bound by these Terms of Service and our Data Usage Policy. If you do not agree to these terms, please do not use our Platform.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">2. DATA STORAGE AND RESPONSIBILITY</h3>
              <p className="mb-2">
                <strong>User Cloud Storage:</strong> All data uploaded and processed through the Platform will be stored in your designated cloud storage solution as specified during account setup. You are solely responsible for:
              </p>
              <ul className="list-disc ml-6 space-y-1">
                <li>Ensuring adequate storage capacity in your cloud storage solution</li>
                <li>Maintaining access credentials and permissions for your cloud storage</li>
                <li>Regular backups of your data stored in your cloud solution</li>
                <li>Monitoring storage usage and managing storage costs</li>
                <li>Compliance with your cloud provider's terms of service</li>
              </ul>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">3. LIMITATION OF LIABILITY</h3>
              <p className="mb-2">
                GreenCard Sustainability Manager ("Company") shall not be liable for:
              </p>
              <ul className="list-disc ml-6 space-y-1">
                <li>Loss, corruption, or inaccessibility of data stored in your cloud storage</li>
                <li>Downtime or unavailability of your chosen cloud storage provider</li>
                <li>Costs associated with your cloud storage usage or overages</li>
                <li>Data breaches occurring at your cloud storage provider level</li>
                <li>Any damages resulting from insufficient storage capacity</li>
                <li>Integration failures between the Platform and your cloud storage</li>
              </ul>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">4. DATA SECURITY AND PRIVACY</h3>
              <p className="mb-2">
                While we implement industry-standard security measures for data transmission and Platform access, you acknowledge that:
              </p>
              <ul className="list-disc ml-6 space-y-1">
                <li>Data security at the storage level is governed by your cloud provider's security measures</li>
                <li>You are responsible for implementing appropriate access controls for your cloud storage</li>
                <li>The Company does not have direct control over your cloud storage security settings</li>
                <li>You must comply with applicable data protection regulations (GDPR, CCPA, etc.)</li>
              </ul>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">5. INDEMNIFICATION</h3>
              <p>
                You agree to indemnify, defend, and hold harmless GreenCard Sustainability Manager, its officers, directors, employees, and agents from and against any and all claims, damages, obligations, losses, liabilities, costs, and expenses (including reasonable attorney fees) arising from:
              </p>
              <ul className="list-disc ml-6 space-y-1">
                <li>Your use of the Platform</li>
                <li>Your violation of these Terms</li>
                <li>Data breaches or security incidents at your cloud storage level</li>
                <li>Loss or corruption of data in your cloud storage</li>
                <li>Your failure to maintain adequate cloud storage capacity</li>
                <li>Any third-party claims related to your data or cloud storage setup</li>
              </ul>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">6. DATA PROCESSING AND ANALYTICS</h3>
              <p className="mb-2">
                The Platform processes your ESG and sustainability data for:
              </p>
              <ul className="list-disc ml-6 space-y-1">
                <li>Generating reports and analytics as requested</li>
                <li>Providing carbon footprint calculations and assessments</li>
                <li>Enabling data visualization and dashboard features</li>
                <li>Facilitating compliance reporting and documentation</li>
              </ul>
              <p className="mt-2">
                Processed data and generated reports are stored in your designated cloud storage and remain under your ownership and control.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">7. SERVICE AVAILABILITY</h3>
              <p>
                While we strive to maintain high service availability, we do not guarantee uninterrupted access to the Platform. Service interruptions may occur due to maintenance, updates, or unforeseen technical issues. We are not liable for any losses resulting from service downtime.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">8. INTELLECTUAL PROPERTY</h3>
              <p>
                The Platform and its underlying technology remain the intellectual property of GreenCard Sustainability Manager. Your data and reports generated from your data remain your intellectual property.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">9. TERMINATION</h3>
              <p>
                Either party may terminate this agreement at any time. Upon termination, your access to the Platform will be discontinued, but your data will remain in your cloud storage under your control.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">10. GOVERNING LAW</h3>
              <p>
                These Terms shall be governed by and construed in accordance with the laws of [Your Jurisdiction], without regard to its conflict of law provisions.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">11. CHANGES TO TERMS</h3>
              <p>
                We reserve the right to modify these Terms at any time. Users will be notified of significant changes via email or Platform notifications.
              </p>
            </section>

            <section>
              <h3 className="text-lg font-semibold mb-2">12. CONTACT INFORMATION</h3>
              <p>
                For questions about these Terms or the Platform, please contact us at support@greencard-sustainability.com
              </p>
            </section>

            <div className="mt-6 p-4 bg-yellow-50 border border-yellow-200 rounded-lg">
              <p className="text-sm font-medium">
                <strong>Important Notice:</strong> By proceeding with account creation, you acknowledge that you have read, understood, and agree to be bound by these Terms and accept full responsibility for your data storage and management.
              </p>
            </div>
          </div>
        </ScrollArea>

        <DialogFooter className="flex justify-between">
          <Button variant="outline" onClick={() => onOpenChange(false)}>
            Cancel
          </Button>
          <Button onClick={onAccept}>
            I Accept These Terms
          </Button>
        </DialogFooter>
      </DialogContent>
    </Dialog>
  );
};
