
import React, { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Badge } from '@/components/ui/badge';
import { Calculator, Zap, Factory, Recycle, Flame, Target } from 'lucide-react';
import { EnergyCalculator } from './EnergyCalculator';
import { WasteCalculator } from './WasteCalculator';
import { ChemicalCalculator } from './ChemicalCalculator';
import { ProductionCalculator } from './ProductionCalculator';
import { CarbonSummary } from './CarbonSummary';

export const CarbonAccountingMain = () => {
  const [refreshData, setRefreshData] = useState(0);

  const handleCalculationUpdate = () => {
    setRefreshData(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Calculator className="h-5 w-5" />
            Carbon Accounting & Emission Calculators
          </CardTitle>
          <p className="text-gray-600">
            Comprehensive carbon accounting with multi-currency support and automated conversions
          </p>
        </CardHeader>
        <CardContent>
          {/* Summary Dashboard */}
          <CarbonSummary key={refreshData} />

          {/* Calculator Tabs */}
          <Tabs defaultValue="energy" className="mt-6">
            <TabsList className="grid w-full grid-cols-4">
              <TabsTrigger value="energy" className="flex items-center gap-2">
                <Zap className="h-4 w-4" />
                Energy
              </TabsTrigger>
              <TabsTrigger value="waste" className="flex items-center gap-2">
                <Recycle className="h-4 w-4" />
                Waste
              </TabsTrigger>
              <TabsTrigger value="chemical" className="flex items-center gap-2">
                <Flame className="h-4 w-4" />
                Chemical
              </TabsTrigger>
              <TabsTrigger value="production" className="flex items-center gap-2">
                <Factory className="h-4 w-4" />
                Production
              </TabsTrigger>
            </TabsList>
            
            <TabsContent value="energy">
              <EnergyCalculator onUpdate={handleCalculationUpdate} />
            </TabsContent>
            
            <TabsContent value="waste">
              <WasteCalculator onUpdate={handleCalculationUpdate} />
            </TabsContent>
            
            <TabsContent value="chemical">
              <ChemicalCalculator onUpdate={handleCalculationUpdate} />
            </TabsContent>
            
            <TabsContent value="production">
              <ProductionCalculator onUpdate={handleCalculationUpdate} />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
};
