
import React from 'react';
import { NavLink, useLocation } from 'react-router-dom';
import {
  BarChart3,
  Database,
  FileText,
  AlertTriangle,
  Leaf,
  Users,
  Target,
  Settings,
  Home
} from 'lucide-react';
import {
  Sidebar,
  SidebarContent,
  SidebarGroup,
  SidebarGroupContent,
  SidebarGroupLabel,
  SidebarMenu,
  SidebarMenuItem,
  SidebarMenuButton,
  useSidebar,
} from "@/components/ui/sidebar";

const navigationItems = [
  { title: 'Dashboard', url: '/', icon: Home },
  { title: 'Data Management', url: '/data-management', icon: Database },
  { title: 'ESG Reporting', url: '/reporting', icon: FileText },
  { title: 'Risk Management', url: '/risk-management', icon: AlertTriangle },
  { title: 'Carbon Accounting', url: '/carbon-accounting', icon: Leaf },
  { title: 'Portfolio Management', url: '/portfolio', icon: BarChart3 },
  { title: 'Net-Zero Pathway', url: '/net-zero', icon: Target },
  { title: 'Supply Chain', url: '/supply-chain', icon: Users },
  { title: 'Settings', url: '/settings', icon: Settings },
];

export function AppSidebar() {
  const { state } = useSidebar();
  const location = useLocation();
  const collapsed = state === 'collapsed';

  const isActive = (path: string) => {
    if (path === '/') return location.pathname === '/';
    return location.pathname.startsWith(path);
  };

  return (
    <Sidebar className={collapsed ? "w-14" : "w-64"} collapsible="icon">
      <SidebarContent>
        <div className="p-4">
          <div className="flex items-center gap-2">
            <div className="h-8 w-8 rounded-full flex items-center justify-center overflow-hidden flex-shrink-0">
              <img 
                src="/lovable-uploads/25df63bc-eca7-461d-9969-367549bcbe24.png" 
                alt="GreenCard Logo" 
                className="h-full w-full object-contain"
              />
            </div>
            {!collapsed && (
              <span className="font-bold text-lg text-green-600">
                GreenCard
              </span>
            )}
          </div>
        </div>
        
        <SidebarGroup>
          <SidebarGroupLabel className={collapsed ? 'hidden' : 'block'}>
            Core Solutions
          </SidebarGroupLabel>
          <SidebarGroupContent>
            <SidebarMenu>
              {navigationItems.map((item) => (
                <SidebarMenuItem key={item.title}>
                  <SidebarMenuButton asChild>
                    <NavLink
                      to={item.url}
                      className={({ isActive }) =>
                        `flex items-center gap-3 px-3 py-2 rounded-md transition-colors ${
                          isActive
                            ? 'bg-green-100 text-green-700 font-medium'
                            : 'text-gray-600 hover:bg-gray-100'
                        }`
                      }
                    >
                      <item.icon className="h-5 w-5 flex-shrink-0" />
                      {!collapsed && <span>{item.title}</span>}
                    </NavLink>
                  </SidebarMenuButton>
                </SidebarMenuItem>
              ))}
            </SidebarMenu>
          </SidebarGroupContent>
        </SidebarGroup>
      </SidebarContent>
    </Sidebar>
  );
}
