
import React, { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Target, TrendingDown, Zap, Building } from 'lucide-react';
import { NetZeroOverview } from './NetZeroOverview';
import { TargetManager } from './TargetManager';
import { InitiativeManager } from './InitiativeManager';
import { PathwayTracker } from './PathwayTracker';

export const NetZeroMain = () => {
  const [refreshData, setRefreshData] = useState(0);

  const handleDataUpdate = () => {
    setRefreshData(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Target className="h-5 w-5" />
            Net-Zero Pathway Management
          </CardTitle>
          <p className="text-gray-600">
            Set targets, track progress, and manage decarbonization initiatives for your net-zero journey
          </p>
        </CardHeader>
        <CardContent>
          <Tabs defaultValue="overview" className="w-full">
            <TabsList className="grid w-full grid-cols-4">
              <TabsTrigger value="overview" className="flex items-center gap-2">
                <Target className="h-4 w-4" />
                Overview
              </TabsTrigger>
              <TabsTrigger value="targets" className="flex items-center gap-2">
                <TrendingDown className="h-4 w-4" />
                Targets
              </TabsTrigger>
              <TabsTrigger value="initiatives" className="flex items-center gap-2">
                <Zap className="h-4 w-4" />
                Initiatives
              </TabsTrigger>
              <TabsTrigger value="tracker" className="flex items-center gap-2">
                <Building className="h-4 w-4" />
                Progress Tracker
              </TabsTrigger>
            </TabsList>
            
            <TabsContent value="overview">
              <NetZeroOverview key={refreshData} />
            </TabsContent>
            
            <TabsContent value="targets">
              <TargetManager onUpdate={handleDataUpdate} />
            </TabsContent>
            
            <TabsContent value="initiatives">
              <InitiativeManager onUpdate={handleDataUpdate} />
            </TabsContent>
            
            <TabsContent value="tracker">
              <PathwayTracker key={refreshData} />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
};
