
import React, { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { TrendingUp, PieChart, BarChart3, Target } from 'lucide-react';
import { PortfolioOverview } from './PortfolioOverview';
import { InvestmentManager } from './InvestmentManager';
import { ESGAnalytics } from './ESGAnalytics';
import { PortfolioReporting } from './PortfolioReporting';

export const PortfolioMain = () => {
  const [refreshData, setRefreshData] = useState(0);

  const handleDataUpdate = () => {
    setRefreshData(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <TrendingUp className="h-5 w-5" />
            Portfolio Management
          </CardTitle>
          <p className="text-gray-600">
            Manage ESG investments and track portfolio sustainability performance
          </p>
        </CardHeader>
        <CardContent>
          <Tabs defaultValue="overview" className="w-full">
            <TabsList className="grid w-full grid-cols-4">
              <TabsTrigger value="overview" className="flex items-center gap-2">
                <PieChart className="h-4 w-4" />
                Overview
              </TabsTrigger>
              <TabsTrigger value="investments" className="flex items-center gap-2">
                <Target className="h-4 w-4" />
                Investments
              </TabsTrigger>
              <TabsTrigger value="analytics" className="flex items-center gap-2">
                <BarChart3 className="h-4 w-4" />
                ESG Analytics
              </TabsTrigger>
              <TabsTrigger value="reporting" className="flex items-center gap-2">
                <TrendingUp className="h-4 w-4" />
                Reporting
              </TabsTrigger>
            </TabsList>
            
            <TabsContent value="overview">
              <PortfolioOverview key={refreshData} />
            </TabsContent>
            
            <TabsContent value="investments">
              <InvestmentManager onUpdate={handleDataUpdate} />
            </TabsContent>
            
            <TabsContent value="analytics">
              <ESGAnalytics key={refreshData} />
            </TabsContent>
            
            <TabsContent value="reporting">
              <PortfolioReporting key={refreshData} />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
};
