
import React from 'react';
import { Card, CardContent } from '@/components/ui/card';

export const StorageRecommendations = () => {
  return (
    <div className="border-t pt-6">
      <h3 className="text-lg font-medium mb-4">Storage Recommendations</h3>
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4 text-sm">
        <Card>
          <CardContent className="p-4">
            <h4 className="font-medium mb-2">Recommended Storage Capacity</h4>
            <ul className="space-y-1 text-gray-600">
              <li>• Small Business: 10-50 GB</li>
              <li>• Medium Enterprise: 100-500 GB</li>
              <li>• Large Corporation: 1-10 TB</li>
            </ul>
          </CardContent>
        </Card>
        
        <Card>
          <CardContent className="p-4">
            <h4 className="font-medium mb-2">Security Best Practices</h4>
            <ul className="space-y-1 text-gray-600">
              <li>• Enable encryption at rest</li>
              <li>• Use strong access controls</li>
              <li>• Enable file versioning</li>
              <li>• Set up automated backups</li>
            </ul>
          </CardContent>
        </Card>
      </div>
    </div>
  );
};
