
import React, { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Settings, User, Bell, Cloud } from 'lucide-react';
import { UserProfileSettings } from './UserProfileSettings';
import { NotificationSettings } from './NotificationSettings';
import { CloudStorageSettings } from './CloudStorageSettings';
import { SystemSettings } from '../DataManagement/SystemSettings';

export const SettingsMain = () => {
  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Settings className="h-5 w-5" />
            Settings
          </CardTitle>
          <p className="text-gray-600">
            Manage your account settings, preferences, cloud storage, and notifications
          </p>
        </CardHeader>
        <CardContent>
          <Tabs defaultValue="profile" className="w-full">
            <TabsList className="grid w-full grid-cols-4">
              <TabsTrigger value="profile" className="flex items-center gap-2">
                <User className="h-4 w-4" />
                Profile
              </TabsTrigger>
              <TabsTrigger value="storage" className="flex items-center gap-2">
                <Cloud className="h-4 w-4" />
                Storage
              </TabsTrigger>
              <TabsTrigger value="notifications" className="flex items-center gap-2">
                <Bell className="h-4 w-4" />
                Notifications
              </TabsTrigger>
              <TabsTrigger value="system" className="flex items-center gap-2">
                <Settings className="h-4 w-4" />
                System
              </TabsTrigger>
            </TabsList>
            
            <TabsContent value="profile">
              <UserProfileSettings />
            </TabsContent>
            
            <TabsContent value="storage">
              <CloudStorageSettings />
            </TabsContent>
            
            <TabsContent value="notifications">
              <NotificationSettings />
            </TabsContent>
            
            <TabsContent value="system">
              <SystemSettings />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
};
