
import React, { useState } from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui/card';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Truck, Users, FileText, BarChart3 } from 'lucide-react';
import { SupplyChainOverview } from './SupplyChainOverview';
import { SupplierManager } from './SupplierManager';
import { AssessmentManager } from './AssessmentManager';
import { SupplyChainAnalytics } from './SupplyChainAnalytics';

export const SupplyChainMain = () => {
  const [refreshData, setRefreshData] = useState(0);

  const handleDataUpdate = () => {
    setRefreshData(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <Card>
        <CardHeader>
          <CardTitle className="flex items-center gap-2">
            <Truck className="h-5 w-5" />
            Supply Chain Assessment
          </CardTitle>
          <p className="text-gray-600">
            Manage supplier relationships and assess supply chain sustainability performance
          </p>
        </CardHeader>
        <CardContent>
          <Tabs defaultValue="overview" className="w-full">
            <TabsList className="grid w-full grid-cols-4">
              <TabsTrigger value="overview" className="flex items-center gap-2">
                <BarChart3 className="h-4 w-4" />
                Overview
              </TabsTrigger>
              <TabsTrigger value="suppliers" className="flex items-center gap-2">
                <Users className="h-4 w-4" />
                Suppliers
              </TabsTrigger>
              <TabsTrigger value="assessments" className="flex items-center gap-2">
                <FileText className="h-4 w-4" />
                Assessments
              </TabsTrigger>
              <TabsTrigger value="analytics" className="flex items-center gap-2">
                <BarChart3 className="h-4 w-4" />
                Analytics
              </TabsTrigger>
            </TabsList>
            
            <TabsContent value="overview">
              <SupplyChainOverview key={refreshData} />
            </TabsContent>
            
            <TabsContent value="suppliers">
              <SupplierManager onUpdate={handleDataUpdate} />
            </TabsContent>
            
            <TabsContent value="assessments">
              <AssessmentManager onUpdate={handleDataUpdate} />
            </TabsContent>
            
            <TabsContent value="analytics">
              <SupplyChainAnalytics key={refreshData} />
            </TabsContent>
          </Tabs>
        </CardContent>
      </Card>
    </div>
  );
};
