
export interface MaterialData {
  id: string;
  name: string;
  category: string;
  calorificValue?: number; // MJ/kg or MJ/m³
  emissionFactor: number; // kg CO2e per unit
  unit: string;
  description: string;
  scope: string;
  alternatives?: string[];
}

export const materialMetrics: MaterialData[] = [
  // Fossil Fuels
  {
    id: "coal-anthracite",
    name: "Anthracite Coal",
    category: "Fossil Fuels",
    calorificValue: 32.5, // MJ/kg
    emissionFactor: 98.3, // kg CO2e/GJ
    unit: "kg",
    description: "High-grade coal with highest energy content",
    scope: "Scope 1",
    alternatives: ["Biomass pellets", "Natural gas"]
  },
  {
    id: "coal-bituminous",
    name: "Bituminous Coal",
    category: "Fossil Fuels",
    calorificValue: 25.8,
    emissionFactor: 94.6,
    unit: "kg",
    description: "Medium-grade coal commonly used in power generation",
    scope: "Scope 1",
    alternatives: ["Renewable energy", "Natural gas"]
  },
  {
    id: "natural-gas",
    name: "Natural Gas",
    category: "Fossil Fuels",
    calorificValue: 38.7, // MJ/m³
    emissionFactor: 56.1,
    unit: "m³",
    description: "Clean-burning fossil fuel",
    scope: "Scope 1",
    alternatives: ["Biogas", "Hydrogen", "Renewable electricity"]
  },
  {
    id: "diesel",
    name: "Diesel Fuel",
    category: "Fossil Fuels",
    calorificValue: 43.1, // MJ/kg
    emissionFactor: 74.1,
    unit: "liters",
    description: "Heavy fuel oil for transportation and generators",
    scope: "Scope 1",
    alternatives: ["Biodiesel", "Electric vehicles", "Hydrogen fuel cells"]
  },
  {
    id: "gasoline",
    name: "Gasoline/Petrol",
    category: "Fossil Fuels",
    calorificValue: 44.4,
    emissionFactor: 69.3,
    unit: "liters",
    description: "Light petroleum fuel for vehicles",
    scope: "Scope 1",
    alternatives: ["Electric vehicles", "Biofuels", "Hybrid systems"]
  },
  {
    id: "lpg",
    name: "Liquefied Petroleum Gas (LPG)",
    category: "Fossil Fuels",
    calorificValue: 46.1,
    emissionFactor: 63.1,
    unit: "kg",
    description: "Propane and butane mixture",
    scope: "Scope 1",
    alternatives: ["Biogas", "Electric heating", "Solar thermal"]
  },
  {
    id: "fuel-oil-heavy",
    name: "Heavy Fuel Oil",
    category: "Fossil Fuels",
    calorificValue: 40.4,
    emissionFactor: 77.4,
    unit: "liters",
    description: "High sulfur content marine and industrial fuel",
    scope: "Scope 1",
    alternatives: ["Marine gas oil", "Ammonia fuel", "Methanol"]
  },
  {
    id: "kerosene",
    name: "Kerosene/Jet Fuel",
    category: "Fossil Fuels",
    calorificValue: 43.15,
    emissionFactor: 71.5,
    unit: "liters",
    description: "Aviation and heating fuel",
    scope: "Scope 1",
    alternatives: ["Sustainable aviation fuel", "Electric aircraft", "Hydrogen aircraft"]
  },

  // Renewable Fuels
  {
    id: "wood-pellets",
    name: "Wood Pellets",
    category: "Biomass",
    calorificValue: 17.5,
    emissionFactor: 0, // Carbon neutral
    unit: "kg",
    description: "Compressed wood waste for heating",
    scope: "Scope 1",
    alternatives: ["Solar heating", "Heat pumps", "Geothermal"]
  },
  {
    id: "wood-chips",
    name: "Wood Chips",
    category: "Biomass",
    calorificValue: 15.0,
    emissionFactor: 0,
    unit: "kg",
    description: "Chipped wood for industrial heating",
    scope: "Scope 1",
    alternatives: ["Wood pellets", "Solar thermal", "Electric heating"]
  },
  {
    id: "biogas",
    name: "Biogas",
    category: "Biomass",
    calorificValue: 23.0,
    emissionFactor: 0,
    unit: "m³",
    description: "Methane from organic waste decomposition",
    scope: "Scope 1",
    alternatives: ["Natural gas", "Solar power", "Wind power"]
  },
  {
    id: "biodiesel",
    name: "Biodiesel (B100)",
    category: "Biomass",
    calorificValue: 37.8,
    emissionFactor: 0,
    unit: "liters",
    description: "100% biodiesel from vegetable oils",
    scope: "Scope 1",
    alternatives: ["Electric vehicles", "Hydrogen fuel cells", "Public transport"]
  },
  {
    id: "ethanol",
    name: "Bioethanol",
    category: "Biomass",
    calorificValue: 26.8,
    emissionFactor: 0,
    unit: "liters",
    description: "Alcohol fuel from plant materials",
    scope: "Scope 1",
    alternatives: ["Electric vehicles", "Gasoline", "Hydrogen"]
  },

  // Industrial Materials - Metals
  {
    id: "steel-production",
    name: "Steel Production",
    category: "Metals",
    emissionFactor: 2100, // kg CO2e/tonne steel
    unit: "tonnes",
    description: "Primary steel production from iron ore",
    scope: "Scope 3",
    alternatives: ["Recycled steel", "Green hydrogen steel", "Electric arc furnace steel"]
  },
  {
    id: "aluminum-primary",
    name: "Primary Aluminum",
    category: "Metals",
    emissionFactor: 11500, // kg CO2e/tonne
    unit: "tonnes",
    description: "Aluminum from bauxite ore",
    scope: "Scope 3",
    alternatives: ["Recycled aluminum", "Low-carbon aluminum", "Alternative materials"]
  },
  {
    id: "aluminum-recycled",
    name: "Recycled Aluminum",
    category: "Metals",
    emissionFactor: 500,
    unit: "tonnes",
    description: "Aluminum from recycled sources",
    scope: "Scope 3",
    alternatives: ["Primary aluminum", "Composite materials", "Steel"]
  },
  {
    id: "copper",
    name: "Copper",
    category: "Metals",
    emissionFactor: 4200,
    unit: "tonnes",
    description: "Copper metal production",
    scope: "Scope 3",
    alternatives: ["Recycled copper", "Aluminum conductors", "Fiber optics"]
  },
  {
    id: "zinc",
    name: "Zinc",
    category: "Metals",
    emissionFactor: 3200,
    unit: "tonnes",
    description: "Zinc metal for galvanizing and alloys",
    scope: "Scope 3",
    alternatives: ["Aluminum coating", "Organic coatings", "Stainless steel"]
  },

  // Construction Materials
  {
    id: "cement-portland",
    name: "Portland Cement",
    category: "Construction",
    emissionFactor: 820,
    unit: "tonnes",
    description: "Standard construction cement",
    scope: "Scope 3",
    alternatives: ["Low-carbon cement", "Geopolymer cement", "Recycled concrete"]
  },
  {
    id: "concrete-ready-mix",
    name: "Ready-Mix Concrete",
    category: "Construction",
    emissionFactor: 350,
    unit: "m³",
    description: "Pre-mixed concrete for construction",
    scope: "Scope 3",
    alternatives: ["Recycled aggregate concrete", "Timber construction", "Steel frame"]
  },
  {
    id: "brick-clay",
    name: "Clay Bricks",
    category: "Construction",
    emissionFactor: 240,
    unit: "thousand bricks",
    description: "Traditional fired clay bricks",
    scope: "Scope 3",
    alternatives: ["Recycled brick", "Concrete blocks", "Timber frame"]
  },
  {
    id: "glass-float",
    name: "Float Glass",
    category: "Construction",
    emissionFactor: 850,
    unit: "tonnes",
    description: "Standard building glass",
    scope: "Scope 3",
    alternatives: ["Recycled glass", "Polycarbonate", "Smart glass"]
  },
  {
    id: "timber-softwood",
    name: "Softwood Timber",
    category: "Construction",
    emissionFactor: -900, // Carbon sequestration
    unit: "m³",
    description: "Sustainably harvested softwood",
    scope: "Scope 3",
    alternatives: ["Hardwood", "Engineered wood", "Steel frame"]
  },

  // Chemicals
  {
    id: "ammonia",
    name: "Ammonia (NH₃)",
    category: "Chemicals",
    emissionFactor: 2100,
    unit: "tonnes",
    description: "Industrial ammonia production",
    scope: "Scope 3",
    alternatives: ["Green ammonia", "Organic fertilizers", "Precision agriculture"]
  },
  {
    id: "methanol",
    name: "Methanol",
    category: "Chemicals",
    emissionFactor: 1370,
    unit: "tonnes",
    description: "Industrial methanol production",
    scope: "Scope 3",
    alternatives: ["Bio-methanol", "Synthetic methanol", "Alternative solvents"]
  },
  {
    id: "plastic-hdpe",
    name: "High-Density Polyethylene (HDPE)",
    category: "Plastics",
    emissionFactor: 1950,
    unit: "tonnes",
    description: "Common plastic for containers and pipes",
    scope: "Scope 3",
    alternatives: ["Recycled HDPE", "Bioplastics", "Paper packaging"]
  },
  {
    id: "plastic-pet",
    name: "Polyethylene Terephthalate (PET)",
    category: "Plastics",
    emissionFactor: 2270,
    unit: "tonnes",
    description: "Plastic for bottles and containers",
    scope: "Scope 3",
    alternatives: ["Recycled PET", "Glass containers", "Aluminum cans"]
  },

  // Paper and Pulp
  {
    id: "paper-newsprint",
    name: "Newsprint Paper",
    category: "Paper",
    emissionFactor: 720,
    unit: "tonnes",
    description: "Low-grade paper for newspapers",
    scope: "Scope 3",
    alternatives: ["Recycled newsprint", "Digital media", "Virgin fiber paper"]
  },
  {
    id: "paper-office",
    name: "Office Paper",
    category: "Paper",
    emissionFactor: 1100,
    unit: "tonnes",
    description: "White office and printing paper",
    scope: "Scope 3",
    alternatives: ["Recycled paper", "Digital documents", "FSC certified paper"]
  },
  {
    id: "cardboard-corrugated",
    name: "Corrugated Cardboard",
    category: "Paper",
    emissionFactor: 950,
    unit: "tonnes",
    description: "Packaging cardboard material",
    scope: "Scope 3",
    alternatives: ["Recycled cardboard", "Reusable packaging", "Biodegradable packaging"]
  },

  // Transportation Fuels (Advanced)
  {
    id: "marine-gas-oil",
    name: "Marine Gas Oil (MGO)",
    category: "Marine Fuels",
    calorificValue: 42.7,
    emissionFactor: 74.1,
    unit: "tonnes",
    description: "Low sulfur marine fuel",
    scope: "Scope 1",
    alternatives: ["Ammonia fuel", "Hydrogen fuel", "Wind-assisted propulsion"]
  },
  {
    id: "bunker-c",
    name: "Bunker C Fuel Oil",
    category: "Marine Fuels",
    calorificValue: 40.2,
    emissionFactor: 77.4,
    unit: "tonnes",
    description: "Heavy marine fuel oil",
    scope: "Scope 1",
    alternatives: ["Marine gas oil", "Liquefied natural gas", "Methanol"]
  },

  // Waste Materials
  {
    id: "waste-municipal",
    name: "Municipal Solid Waste",
    category: "Waste",
    emissionFactor: 470, // kg CO2e/tonne when landfilled
    unit: "tonnes",
    description: "General household and commercial waste",
    scope: "Scope 3",
    alternatives: ["Recycling", "Composting", "Waste-to-energy", "Source reduction"]
  },
  {
    id: "waste-organic",
    name: "Organic Waste",
    category: "Waste",
    emissionFactor: 340,
    unit: "tonnes",
    description: "Food waste and organic materials",
    scope: "Scope 3",
    alternatives: ["Composting", "Anaerobic digestion", "Animal feed", "Source reduction"]
  }
];

export const materialCategories = [
  "All Materials",
  "Fossil Fuels",
  "Biomass",
  "Metals",
  "Construction",
  "Chemicals",
  "Plastics",
  "Paper",
  "Marine Fuels",
  "Waste"
];
