export type Json =
  | string
  | number
  | boolean
  | null
  | { [key: string]: Json | undefined }
  | Json[]

export type Database = {
  public: {
    Tables: {
      audit_logs: {
        Row: {
          action: string
          details: Json | null
          id: string
          timestamp: string
          user_email: string | null
          user_id: string
        }
        Insert: {
          action: string
          details?: Json | null
          id?: string
          timestamp?: string
          user_email?: string | null
          user_id: string
        }
        Update: {
          action?: string
          details?: Json | null
          id?: string
          timestamp?: string
          user_email?: string | null
          user_id?: string
        }
        Relationships: []
      }
      carbon_calculations: {
        Row: {
          activity_name: string
          amount: number
          calculation_date: string
          calculation_type: string
          co2_equivalent: number
          created_at: string
          emission_factor: number
          exchange_rate: number | null
          id: string
          local_amount: number | null
          local_currency: string | null
          scope: string
          unit: string
          updated_at: string
          usd_amount: number | null
          user_id: string
        }
        Insert: {
          activity_name: string
          amount: number
          calculation_date?: string
          calculation_type: string
          co2_equivalent: number
          created_at?: string
          emission_factor: number
          exchange_rate?: number | null
          id?: string
          local_amount?: number | null
          local_currency?: string | null
          scope: string
          unit: string
          updated_at?: string
          usd_amount?: number | null
          user_id: string
        }
        Update: {
          activity_name?: string
          amount?: number
          calculation_date?: string
          calculation_type?: string
          co2_equivalent?: number
          created_at?: string
          emission_factor?: number
          exchange_rate?: number | null
          id?: string
          local_amount?: number | null
          local_currency?: string | null
          scope?: string
          unit?: string
          updated_at?: string
          usd_amount?: number | null
          user_id?: string
        }
        Relationships: []
      }
      currency_rates: {
        Row: {
          country: string | null
          currency_code: string
          id: string
          region: string | null
          updated_at: string
          usd_rate: number
        }
        Insert: {
          country?: string | null
          currency_code: string
          id?: string
          region?: string | null
          updated_at?: string
          usd_rate: number
        }
        Update: {
          country?: string | null
          currency_code?: string
          id?: string
          region?: string | null
          updated_at?: string
          usd_rate?: number
        }
        Relationships: []
      }
      decarbonization_initiatives: {
        Row: {
          actual_reduction: number | null
          completion_date: string | null
          created_at: string
          currency: string | null
          description: string | null
          estimated_reduction: number
          id: string
          implementation_date: string | null
          initiative_name: string
          initiative_type: string
          investment_required: number | null
          priority_level: string | null
          responsible_team: string | null
          roi_percentage: number | null
          status: string | null
          target_id: string | null
          updated_at: string
          user_id: string
        }
        Insert: {
          actual_reduction?: number | null
          completion_date?: string | null
          created_at?: string
          currency?: string | null
          description?: string | null
          estimated_reduction: number
          id?: string
          implementation_date?: string | null
          initiative_name: string
          initiative_type: string
          investment_required?: number | null
          priority_level?: string | null
          responsible_team?: string | null
          roi_percentage?: number | null
          status?: string | null
          target_id?: string | null
          updated_at?: string
          user_id: string
        }
        Update: {
          actual_reduction?: number | null
          completion_date?: string | null
          created_at?: string
          currency?: string | null
          description?: string | null
          estimated_reduction?: number
          id?: string
          implementation_date?: string | null
          initiative_name?: string
          initiative_type?: string
          investment_required?: number | null
          priority_level?: string | null
          responsible_team?: string | null
          roi_percentage?: number | null
          status?: string | null
          target_id?: string | null
          updated_at?: string
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "decarbonization_initiatives_target_id_fkey"
            columns: ["target_id"]
            isOneToOne: false
            referencedRelation: "net_zero_targets"
            referencedColumns: ["id"]
          },
        ]
      }
      esg_data_categories: {
        Row: {
          category_type: string
          created_at: string | null
          description: string | null
          id: string
          name: string
        }
        Insert: {
          category_type: string
          created_at?: string | null
          description?: string | null
          id?: string
          name: string
        }
        Update: {
          category_type?: string
          created_at?: string | null
          description?: string | null
          id?: string
          name?: string
        }
        Relationships: []
      }
      esg_data_points: {
        Row: {
          category_id: string | null
          created_at: string | null
          data_source: string | null
          id: string
          metric_name: string
          metric_value: number | null
          reporting_period: string | null
          scope: string | null
          unit: string | null
          updated_at: string | null
          user_id: string | null
          validation_status: string | null
        }
        Insert: {
          category_id?: string | null
          created_at?: string | null
          data_source?: string | null
          id?: string
          metric_name: string
          metric_value?: number | null
          reporting_period?: string | null
          scope?: string | null
          unit?: string | null
          updated_at?: string | null
          user_id?: string | null
          validation_status?: string | null
        }
        Update: {
          category_id?: string | null
          created_at?: string | null
          data_source?: string | null
          id?: string
          metric_name?: string
          metric_value?: number | null
          reporting_period?: string | null
          scope?: string | null
          unit?: string | null
          updated_at?: string | null
          user_id?: string | null
          validation_status?: string | null
        }
        Relationships: [
          {
            foreignKeyName: "esg_data_points_category_id_fkey"
            columns: ["category_id"]
            isOneToOne: false
            referencedRelation: "esg_data_categories"
            referencedColumns: ["id"]
          },
        ]
      }
      net_zero_targets: {
        Row: {
          baseline_emissions: number
          baseline_year: number
          created_at: string
          current_emissions: number | null
          id: string
          methodology: string | null
          progress_percentage: number | null
          reduction_percentage: number | null
          scope: string
          status: string | null
          target_emissions: number
          target_name: string
          target_type: string
          target_year: number
          updated_at: string
          user_id: string
          verification_status: string | null
        }
        Insert: {
          baseline_emissions: number
          baseline_year: number
          created_at?: string
          current_emissions?: number | null
          id?: string
          methodology?: string | null
          progress_percentage?: number | null
          reduction_percentage?: number | null
          scope: string
          status?: string | null
          target_emissions: number
          target_name: string
          target_type: string
          target_year: number
          updated_at?: string
          user_id: string
          verification_status?: string | null
        }
        Update: {
          baseline_emissions?: number
          baseline_year?: number
          created_at?: string
          current_emissions?: number | null
          id?: string
          methodology?: string | null
          progress_percentage?: number | null
          reduction_percentage?: number | null
          scope?: string
          status?: string | null
          target_emissions?: number
          target_name?: string
          target_type?: string
          target_year?: number
          updated_at?: string
          user_id?: string
          verification_status?: string | null
        }
        Relationships: []
      }
      notification_preferences: {
        Row: {
          additional_emails: string[] | null
          assessment_due_alerts: boolean | null
          created_at: string
          data_validation_alerts: boolean | null
          email_notifications: boolean | null
          id: string
          monthly_reports: boolean | null
          notification_frequency: string | null
          push_notifications: boolean | null
          quiet_hours_end: string | null
          quiet_hours_start: string | null
          report_reminders: boolean | null
          target_deadline_alerts: boolean | null
          threshold_breach_alerts: boolean | null
          updated_at: string
          user_id: string
          weekly_summary: boolean | null
        }
        Insert: {
          additional_emails?: string[] | null
          assessment_due_alerts?: boolean | null
          created_at?: string
          data_validation_alerts?: boolean | null
          email_notifications?: boolean | null
          id?: string
          monthly_reports?: boolean | null
          notification_frequency?: string | null
          push_notifications?: boolean | null
          quiet_hours_end?: string | null
          quiet_hours_start?: string | null
          report_reminders?: boolean | null
          target_deadline_alerts?: boolean | null
          threshold_breach_alerts?: boolean | null
          updated_at?: string
          user_id: string
          weekly_summary?: boolean | null
        }
        Update: {
          additional_emails?: string[] | null
          assessment_due_alerts?: boolean | null
          created_at?: string
          data_validation_alerts?: boolean | null
          email_notifications?: boolean | null
          id?: string
          monthly_reports?: boolean | null
          notification_frequency?: string | null
          push_notifications?: boolean | null
          quiet_hours_end?: string | null
          quiet_hours_start?: string | null
          report_reminders?: boolean | null
          target_deadline_alerts?: boolean | null
          threshold_breach_alerts?: boolean | null
          updated_at?: string
          user_id?: string
          weekly_summary?: boolean | null
        }
        Relationships: []
      }
      portfolio_investments: {
        Row: {
          carbon_intensity: number | null
          created_at: string
          currency: string | null
          environmental_score: number | null
          esg_score: number | null
          governance_score: number | null
          id: string
          investment_amount: number
          investment_date: string
          investment_name: string
          investment_type: string
          last_reviewed: string | null
          notes: string | null
          region: string | null
          sector: string | null
          social_score: number | null
          status: string | null
          updated_at: string
          user_id: string
          waste_intensity: number | null
          water_intensity: number | null
        }
        Insert: {
          carbon_intensity?: number | null
          created_at?: string
          currency?: string | null
          environmental_score?: number | null
          esg_score?: number | null
          governance_score?: number | null
          id?: string
          investment_amount: number
          investment_date: string
          investment_name: string
          investment_type: string
          last_reviewed?: string | null
          notes?: string | null
          region?: string | null
          sector?: string | null
          social_score?: number | null
          status?: string | null
          updated_at?: string
          user_id: string
          waste_intensity?: number | null
          water_intensity?: number | null
        }
        Update: {
          carbon_intensity?: number | null
          created_at?: string
          currency?: string | null
          environmental_score?: number | null
          esg_score?: number | null
          governance_score?: number | null
          id?: string
          investment_amount?: number
          investment_date?: string
          investment_name?: string
          investment_type?: string
          last_reviewed?: string | null
          notes?: string | null
          region?: string | null
          sector?: string | null
          social_score?: number | null
          status?: string | null
          updated_at?: string
          user_id?: string
          waste_intensity?: number | null
          water_intensity?: number | null
        }
        Relationships: []
      }
      report_templates: {
        Row: {
          created_at: string
          description: string | null
          id: string
          is_public: boolean | null
          name: string
          template_data: Json
          template_type: string
          updated_at: string
        }
        Insert: {
          created_at?: string
          description?: string | null
          id?: string
          is_public?: boolean | null
          name: string
          template_data: Json
          template_type: string
          updated_at?: string
        }
        Update: {
          created_at?: string
          description?: string | null
          id?: string
          is_public?: boolean | null
          name?: string
          template_data?: Json
          template_type?: string
          updated_at?: string
        }
        Relationships: []
      }
      risk_assessments: {
        Row: {
          created_at: string
          id: string
          impact: number | null
          likelihood: number | null
          mitigation_strategy: string | null
          responsible_person: string | null
          review_date: string | null
          risk_category: string
          risk_description: string | null
          risk_name: string
          risk_score: number | null
          status: string | null
          updated_at: string
          user_id: string
        }
        Insert: {
          created_at?: string
          id?: string
          impact?: number | null
          likelihood?: number | null
          mitigation_strategy?: string | null
          responsible_person?: string | null
          review_date?: string | null
          risk_category: string
          risk_description?: string | null
          risk_name: string
          risk_score?: number | null
          status?: string | null
          updated_at?: string
          user_id: string
        }
        Update: {
          created_at?: string
          id?: string
          impact?: number | null
          likelihood?: number | null
          mitigation_strategy?: string | null
          responsible_person?: string | null
          review_date?: string | null
          risk_category?: string
          risk_description?: string | null
          risk_name?: string
          risk_score?: number | null
          status?: string | null
          updated_at?: string
          user_id?: string
        }
        Relationships: []
      }
      suppliers: {
        Row: {
          annual_spend: number | null
          carbon_footprint: number | null
          certification_standards: string[] | null
          contact_email: string | null
          contact_phone: string | null
          country: string | null
          created_at: string
          currency: string | null
          environmental_compliance: boolean | null
          esg_assessment_score: number | null
          governance_compliance: boolean | null
          id: string
          industry_sector: string | null
          labor_practices_score: number | null
          last_assessment_date: string | null
          next_assessment_date: string | null
          region: string | null
          risk_level: string | null
          social_compliance: boolean | null
          status: string | null
          supplier_name: string
          supplier_type: string
          updated_at: string
          user_id: string
          waste_generation: number | null
          water_usage: number | null
        }
        Insert: {
          annual_spend?: number | null
          carbon_footprint?: number | null
          certification_standards?: string[] | null
          contact_email?: string | null
          contact_phone?: string | null
          country?: string | null
          created_at?: string
          currency?: string | null
          environmental_compliance?: boolean | null
          esg_assessment_score?: number | null
          governance_compliance?: boolean | null
          id?: string
          industry_sector?: string | null
          labor_practices_score?: number | null
          last_assessment_date?: string | null
          next_assessment_date?: string | null
          region?: string | null
          risk_level?: string | null
          social_compliance?: boolean | null
          status?: string | null
          supplier_name: string
          supplier_type: string
          updated_at?: string
          user_id: string
          waste_generation?: number | null
          water_usage?: number | null
        }
        Update: {
          annual_spend?: number | null
          carbon_footprint?: number | null
          certification_standards?: string[] | null
          contact_email?: string | null
          contact_phone?: string | null
          country?: string | null
          created_at?: string
          currency?: string | null
          environmental_compliance?: boolean | null
          esg_assessment_score?: number | null
          governance_compliance?: boolean | null
          id?: string
          industry_sector?: string | null
          labor_practices_score?: number | null
          last_assessment_date?: string | null
          next_assessment_date?: string | null
          region?: string | null
          risk_level?: string | null
          social_compliance?: boolean | null
          status?: string | null
          supplier_name?: string
          supplier_type?: string
          updated_at?: string
          user_id?: string
          waste_generation?: number | null
          water_usage?: number | null
        }
        Relationships: []
      }
      supply_chain_assessments: {
        Row: {
          action_items: string | null
          assessment_date: string
          assessment_type: string
          assessor_name: string | null
          created_at: string
          environmental_score: number | null
          findings: string | null
          follow_up_date: string | null
          governance_score: number | null
          id: string
          overall_score: number | null
          recommendations: string | null
          social_score: number | null
          status: string | null
          supplier_id: string | null
          updated_at: string
          user_id: string
        }
        Insert: {
          action_items?: string | null
          assessment_date: string
          assessment_type: string
          assessor_name?: string | null
          created_at?: string
          environmental_score?: number | null
          findings?: string | null
          follow_up_date?: string | null
          governance_score?: number | null
          id?: string
          overall_score?: number | null
          recommendations?: string | null
          social_score?: number | null
          status?: string | null
          supplier_id?: string | null
          updated_at?: string
          user_id: string
        }
        Update: {
          action_items?: string | null
          assessment_date?: string
          assessment_type?: string
          assessor_name?: string | null
          created_at?: string
          environmental_score?: number | null
          findings?: string | null
          follow_up_date?: string | null
          governance_score?: number | null
          id?: string
          overall_score?: number | null
          recommendations?: string | null
          social_score?: number | null
          status?: string | null
          supplier_id?: string | null
          updated_at?: string
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "supply_chain_assessments_supplier_id_fkey"
            columns: ["supplier_id"]
            isOneToOne: false
            referencedRelation: "suppliers"
            referencedColumns: ["id"]
          },
        ]
      }
      sustainability_reports: {
        Row: {
          configuration: Json | null
          created_at: string | null
          generated_at: string | null
          id: string
          report_name: string
          report_type: string | null
          standards: string[] | null
          status: string | null
          user_id: string | null
        }
        Insert: {
          configuration?: Json | null
          created_at?: string | null
          generated_at?: string | null
          id?: string
          report_name: string
          report_type?: string | null
          standards?: string[] | null
          status?: string | null
          user_id?: string | null
        }
        Update: {
          configuration?: Json | null
          created_at?: string | null
          generated_at?: string | null
          id?: string
          report_name?: string
          report_type?: string | null
          standards?: string[] | null
          status?: string | null
          user_id?: string | null
        }
        Relationships: []
      }
      team_members: {
        Row: {
          created_at: string
          email: string
          full_name: string
          id: string
          organization_id: string
          profile_picture: string | null
          role: string
          updated_at: string
        }
        Insert: {
          created_at?: string
          email: string
          full_name: string
          id?: string
          organization_id: string
          profile_picture?: string | null
          role?: string
          updated_at?: string
        }
        Update: {
          created_at?: string
          email?: string
          full_name?: string
          id?: string
          organization_id?: string
          profile_picture?: string | null
          role?: string
          updated_at?: string
        }
        Relationships: []
      }
      user_profiles: {
        Row: {
          bio: string | null
          company_name: string | null
          created_at: string | null
          department: string | null
          expertise_areas: string[] | null
          full_name: string | null
          id: string
          job_title: string | null
          linkedin_profile: string | null
          location: string | null
          phone: string | null
          profile_picture: string | null
          role: Database["public"]["Enums"]["user_role"]
          updated_at: string | null
          user_id: string | null
        }
        Insert: {
          bio?: string | null
          company_name?: string | null
          created_at?: string | null
          department?: string | null
          expertise_areas?: string[] | null
          full_name?: string | null
          id?: string
          job_title?: string | null
          linkedin_profile?: string | null
          location?: string | null
          phone?: string | null
          profile_picture?: string | null
          role?: Database["public"]["Enums"]["user_role"]
          updated_at?: string | null
          user_id?: string | null
        }
        Update: {
          bio?: string | null
          company_name?: string | null
          created_at?: string | null
          department?: string | null
          expertise_areas?: string[] | null
          full_name?: string | null
          id?: string
          job_title?: string | null
          linkedin_profile?: string | null
          location?: string | null
          phone?: string | null
          profile_picture?: string | null
          role?: Database["public"]["Enums"]["user_role"]
          updated_at?: string | null
          user_id?: string | null
        }
        Relationships: []
      }
      user_report_customizations: {
        Row: {
          created_at: string
          customizations: Json
          id: string
          template_id: string
          updated_at: string
          user_id: string
        }
        Insert: {
          created_at?: string
          customizations: Json
          id?: string
          template_id: string
          updated_at?: string
          user_id: string
        }
        Update: {
          created_at?: string
          customizations?: Json
          id?: string
          template_id?: string
          updated_at?: string
          user_id?: string
        }
        Relationships: [
          {
            foreignKeyName: "user_report_customizations_template_id_fkey"
            columns: ["template_id"]
            isOneToOne: false
            referencedRelation: "report_templates"
            referencedColumns: ["id"]
          },
        ]
      }
    }
    Views: {
      [_ in never]: never
    }
    Functions: {
      [_ in never]: never
    }
    Enums: {
      user_role: "admin" | "data_entry" | "analyst" | "executive"
    }
    CompositeTypes: {
      [_ in never]: never
    }
  }
}

type DefaultSchema = Database[Extract<keyof Database, "public">]

export type Tables<
  DefaultSchemaTableNameOrOptions extends
    | keyof (DefaultSchema["Tables"] & DefaultSchema["Views"])
    | { schema: keyof Database },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof Database
  }
    ? keyof (Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
        Database[DefaultSchemaTableNameOrOptions["schema"]]["Views"])
    : never = never,
> = DefaultSchemaTableNameOrOptions extends { schema: keyof Database }
  ? (Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"] &
      Database[DefaultSchemaTableNameOrOptions["schema"]]["Views"])[TableName] extends {
      Row: infer R
    }
    ? R
    : never
  : DefaultSchemaTableNameOrOptions extends keyof (DefaultSchema["Tables"] &
        DefaultSchema["Views"])
    ? (DefaultSchema["Tables"] &
        DefaultSchema["Views"])[DefaultSchemaTableNameOrOptions] extends {
        Row: infer R
      }
      ? R
      : never
    : never

export type TablesInsert<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof Database },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof Database
  }
    ? keyof Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends { schema: keyof Database }
  ? Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Insert: infer I
    }
    ? I
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Insert: infer I
      }
      ? I
      : never
    : never

export type TablesUpdate<
  DefaultSchemaTableNameOrOptions extends
    | keyof DefaultSchema["Tables"]
    | { schema: keyof Database },
  TableName extends DefaultSchemaTableNameOrOptions extends {
    schema: keyof Database
  }
    ? keyof Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"]
    : never = never,
> = DefaultSchemaTableNameOrOptions extends { schema: keyof Database }
  ? Database[DefaultSchemaTableNameOrOptions["schema"]]["Tables"][TableName] extends {
      Update: infer U
    }
    ? U
    : never
  : DefaultSchemaTableNameOrOptions extends keyof DefaultSchema["Tables"]
    ? DefaultSchema["Tables"][DefaultSchemaTableNameOrOptions] extends {
        Update: infer U
      }
      ? U
      : never
    : never

export type Enums<
  DefaultSchemaEnumNameOrOptions extends
    | keyof DefaultSchema["Enums"]
    | { schema: keyof Database },
  EnumName extends DefaultSchemaEnumNameOrOptions extends {
    schema: keyof Database
  }
    ? keyof Database[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"]
    : never = never,
> = DefaultSchemaEnumNameOrOptions extends { schema: keyof Database }
  ? Database[DefaultSchemaEnumNameOrOptions["schema"]]["Enums"][EnumName]
  : DefaultSchemaEnumNameOrOptions extends keyof DefaultSchema["Enums"]
    ? DefaultSchema["Enums"][DefaultSchemaEnumNameOrOptions]
    : never

export type CompositeTypes<
  PublicCompositeTypeNameOrOptions extends
    | keyof DefaultSchema["CompositeTypes"]
    | { schema: keyof Database },
  CompositeTypeName extends PublicCompositeTypeNameOrOptions extends {
    schema: keyof Database
  }
    ? keyof Database[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"]
    : never = never,
> = PublicCompositeTypeNameOrOptions extends { schema: keyof Database }
  ? Database[PublicCompositeTypeNameOrOptions["schema"]]["CompositeTypes"][CompositeTypeName]
  : PublicCompositeTypeNameOrOptions extends keyof DefaultSchema["CompositeTypes"]
    ? DefaultSchema["CompositeTypes"][PublicCompositeTypeNameOrOptions]
    : never

export const Constants = {
  public: {
    Enums: {
      user_role: ["admin", "data_entry", "analyst", "executive"],
    },
  },
} as const
