import React, { useState } from 'react';
import { DataEntryModal } from '@/components/DataManagement/DataEntryModal';
import { OrganizationDataManager } from '@/components/DataManagement/OrganizationDataManager';
import { MetricsLibrary } from '@/components/DataManagement/MetricsLibrary';
import { MaterialsLibrary } from '@/components/DataManagement/MaterialsLibrary';
import { SystemSettings } from '@/components/DataManagement/SystemSettings';
import { DashboardCharts } from '@/components/Analytics/DashboardCharts';
import { Tabs, TabsContent, TabsList, TabsTrigger } from '@/components/ui/tabs';
import { Button } from '@/components/ui/button';
import { Badge } from '@/components/ui/badge';
import { Database, Upload, BarChart3, CheckCircle2, BookOpen, Settings, Flame, TrendingUp, Plus } from 'lucide-react';
import { MetricSearchModal } from '@/components/DataManagement/MetricSearchModal';

const DataManagement = () => {
  const [refreshData, setRefreshData] = useState(0);
  const [isDataEntryModalOpen, setIsDataEntryModalOpen] = useState(false);
  const [isMetricSearchModalOpen, setIsMetricSearchModalOpen] = useState(false);

  const handleUploadSuccess = () => {
    setRefreshData(prev => prev + 1);
  };

  return (
    <div className="space-y-6">
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-3xl font-bold text-gray-900">Data Management</h1>
          <p className="text-gray-600 mt-2">
            Comprehensive ESG data management with organization-specific tracking, team collaboration, and real-time analytics
          </p>
        </div>
        <div className="flex gap-4 items-center">
          <div className="flex gap-2">
            <Badge variant="outline" className="flex items-center gap-1">
              <Database className="h-3 w-3" />
              1,500+ Metrics
            </Badge>
            <Badge variant="outline" className="flex items-center gap-1">
              <Flame className="h-3 w-3" />
              Materials Database
            </Badge>
            <Badge variant="outline" className="flex items-center gap-1">
              <CheckCircle2 className="h-3 w-3" />
              AI Validation
            </Badge>
          </div>
          <Button onClick={() => setIsMetricSearchModalOpen(true)} className="flex items-center gap-2">
            <Plus className="h-4 w-4" />
            Add Data Point
          </Button>
        </div>
      </div>

      <Tabs defaultValue="manage" className="space-y-4">
        <TabsList className="grid w-full grid-cols-6">
          <TabsTrigger value="manage" className="flex items-center gap-2">
            <Database className="h-4 w-4" />
            Manage Data
          </TabsTrigger>
          <TabsTrigger value="library" className="flex items-center gap-2">
            <BookOpen className="h-4 w-4" />
            Metrics Library
          </TabsTrigger>
          <TabsTrigger value="materials" className="flex items-center gap-2">
            <Flame className="h-4 w-4" />
            Materials
          </TabsTrigger>
          <TabsTrigger value="analytics" className="flex items-center gap-2">
            <TrendingUp className="h-4 w-4" />
            Analytics
          </TabsTrigger>
          <TabsTrigger value="settings" className="flex items-center gap-2">
            <Settings className="h-4 w-4" />
            Settings
          </TabsTrigger>
          <TabsTrigger value="integrations" className="flex items-center gap-2">
            <Upload className="h-4 w-4" />
            Integrations
          </TabsTrigger>
        </TabsList>

        <TabsContent value="manage" className="space-y-4">
          <OrganizationDataManager key={refreshData} />
        </TabsContent>

        <TabsContent value="library" className="space-y-4">
          <MetricsLibrary />
        </TabsContent>

        <TabsContent value="materials" className="space-y-4">
          <MaterialsLibrary />
        </TabsContent>

        <TabsContent value="analytics" className="space-y-4">
          <DashboardCharts />
        </TabsContent>

        <TabsContent value="settings" className="space-y-4">
          <SystemSettings />
        </TabsContent>

        <TabsContent value="integrations" className="space-y-4">
          <div className="text-center py-12">
            <Upload className="h-12 w-12 text-gray-400 mx-auto mb-4" />
            <h3 className="text-lg font-medium text-gray-900 mb-2">External Integrations</h3>
            <p className="text-gray-600 mb-4">
              Connect with external data sources, accounting systems, and IoT devices
            </p>
            <Button onClick={() => setIsDataEntryModalOpen(true)}>
              Configure Integration
            </Button>
          </div>
        </TabsContent>
      </Tabs>

      <DataEntryModal
        isOpen={isDataEntryModalOpen}
        onClose={() => setIsDataEntryModalOpen(false)}
        onSuccess={handleUploadSuccess}
      />

      <MetricSearchModal
        isOpen={isMetricSearchModalOpen}
        onClose={() => setIsMetricSearchModalOpen(false)}
        onSuccess={handleUploadSuccess}
      />
    </div>
  );
};

export default DataManagement;
