
import React from 'react';
import { ReportBuilder } from '@/components/Reporting/ReportBuilder';
import { Card, CardContent, CardDescription, CardHeader, CardTitle } from '@/components/ui/card';
import { Badge } from '@/components/ui/badge';
import { FileText, Globe, Award, BarChart3 } from 'lucide-react';

const ESGReporting = () => {
  return (
    <div className="space-y-6">
      <div className="flex justify-between items-center">
        <div>
          <h1 className="text-3xl font-bold text-gray-900">ESG Reporting</h1>
          <p className="text-gray-600 mt-2">
            Generate comprehensive sustainability reports with GreenCard Sustainability Manager
          </p>
        </div>
        <div className="flex gap-2">
          <Badge variant="outline" className="flex items-center gap-1">
            <Globe className="h-3 w-3" />
            Multi-Standard
          </Badge>
          <Badge variant="outline" className="flex items-center gap-1">
            <Award className="h-3 w-3" />
            Compliance Ready
          </Badge>
          <Badge variant="outline" className="flex items-center gap-1">
            <BarChart3 className="h-3 w-3" />
            Data-Driven
          </Badge>
        </div>
      </div>

      {/* Feature Highlights */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-4">
        <Card>
          <CardHeader className="pb-3">
            <div className="flex items-center gap-2">
              <FileText className="h-5 w-5 text-blue-600" />
              <CardTitle className="text-lg">Multi-Standard Reports</CardTitle>
            </div>
          </CardHeader>
          <CardContent>
            <CardDescription>
              Support for GRI, TCFD, SASB, CDP, IFRS S2, and SDGs with automatic standard code mapping
            </CardDescription>
          </CardContent>
        </Card>
        
        <Card>
          <CardHeader className="pb-3">
            <div className="flex items-center gap-2">
              <Globe className="h-5 w-5 text-green-600" />
              <CardTitle className="text-lg">Live Preview & Filters</CardTitle>
            </div>
          </CardHeader>
          <CardContent>
            <CardDescription>
              Real-time report preview with comprehensive filtering by standards, timeframes, and categories
            </CardDescription>
          </CardContent>
        </Card>
        
        <Card>
          <CardHeader className="pb-3">
            <div className="flex items-center gap-2">
              <BarChart3 className="h-5 w-5 text-purple-600" />
              <CardTitle className="text-lg">Data Integration</CardTitle>
            </div>
          </CardHeader>
          <CardContent>
            <CardDescription>
              Seamless integration with your organization's ESG data for accurate and up-to-date reporting
            </CardDescription>
          </CardContent>
        </Card>
      </div>

      <ReportBuilder />
    </div>
  );
};

export default ESGReporting;
